/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media.events;

import org.watermedia.videolan4j.binding.internal.libvlc_event_e;
import org.watermedia.videolan4j.binding.internal.libvlc_event_t;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.media.Media;
import org.watermedia.videolan4j.media.events.MediaDurationChangedEvent;
import org.watermedia.videolan4j.media.events.MediaEvent;
import org.watermedia.videolan4j.media.events.MediaFreedEvent;
import org.watermedia.videolan4j.media.events.MediaMetaChangedEvent;
import org.watermedia.videolan4j.media.events.MediaParsedChangedEvent;
import org.watermedia.videolan4j.media.events.MediaStateChangedEvent;
import org.watermedia.videolan4j.media.events.MediaSubItemAddedEvent;
import org.watermedia.videolan4j.media.events.MediaSubItemTreeAddedEvent;
import org.watermedia.videolan4j.media.events.MediaThumbnailGeneratedEvent;

public final class MediaEventFactory {
    public static MediaEvent createEvent(libvlc_instance_t libvlcInstance, Media media, libvlc_event_t event) {
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaMetaChanged: {
                return new MediaMetaChangedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaSubItemAdded: {
                return new MediaSubItemAddedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaDurationChanged: {
                return new MediaDurationChangedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaParsedChanged: {
                return new MediaParsedChangedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaFreed: {
                return new MediaFreedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaStateChanged: {
                return new MediaStateChangedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaSubItemTreeAdded: {
                return new MediaSubItemTreeAddedEvent(libvlcInstance, media, event);
            }
            case libvlc_MediaThumbnailGenerated: {
                return new MediaThumbnailGeneratedEvent(libvlcInstance, media, event);
            }
        }
        return null;
    }

    private MediaEventFactory() {
    }
}

